<?php
   /*
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreRisorsaSingola extends VisualizzatoreComponente {
        private $gestoreTraduzioni;
        private $tutteLeCategorie;
        private $lingua;

        function __construct($db) {
            parent::__construct($db);
            $this->tutteLeCategorie = ".nessunaCategoria, "; // questo spazio non va rimosso
        }
        
        function generaContenutoSezione($dati) {

            $etichettaDownload = $this->gestoreTraduzioni->traduci("Scarica",$this->lingua);
            $elemento = parent::getDb()->leggiSingolaRiga("geecB_risorse",$dati["idElemento"]);

            if($elemento["percorso"]=="") {
                parent::messaggioDiErrore("La risorsa non è stata configurata");
            }
            else {
                $arrayOpzioni               = explode(";",$dati["altreOpzioni"]);
                $arrayOpzioneSpazioOccupato = explode("=",$arrayOpzioni[0]);
                $spazioOccupato             = str_replace(";","",$arrayOpzioneSpazioOccupato[1]);

                echo"<div class=\"$spazioOccupato\">";
                echo $this->codiceElemento($elemento,$dati,$etichettaDownload);
                echo"</div>";
            }
        }
        
        function codiceElemento($elemento,$dati,$etichettaDownload) {
            $dataCreazione = date("d/m/Y",strtotime(str_replace("/","-",$elemento["dataCreazione"])));
            if($elemento["immagine"]!="") {
                return "<div class=\"singolaRisorsa text-center\">
                    <div class=\"p-3 bg-light rounded\">
                        <div class=\"background-image aspect-ratio-16-9 mb-2\" style=\"background: url(\'{$elemento["immagine"]}\')\"></div>
                        <h5>{$dati["altreOpzioni"]}</h5>
                        <p class=\"text-muted\"><i class=\"fas fa-calendar-alt mr-2\"></i>$dataCreazione</p>
                        <p>{$elemento["descrizione"]}</p>
                        <a class=\"btn btn-primary  scarica\" href=\"scaricaFile.php?id={$elemento["id"]}\">$etichettaDownload </a>
                    </div>
                </div>";
            }
            else {               
                return "<div class=\"singolaRisorsa text-center\">
                    <div class=\"p-3 bg-light rounded\">
                        <h5>{$elemento["nome"]}</h5>
                        <p class=\"text-muted\"><i class=\"fas fa-calendar-alt mr-2\"></i>$dataCreazione</p>
                        <p>{$elemento["descrizione"]}</p>
                        <a class=\"btn btn-primary  scarica\" href=\"scaricaFile.php?id={$elemento["id"]}\">$etichettaDownload </a>
                    </div>
                </div>";
            }
        }
        
        // getter & setter
        function getLingua() {
            return $this->lingua;
        }

        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }
        
        function setLingua($lingua) {
            $this->lingua = $lingua;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

    }
